/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.php.internal.parser.PHPTokenType;
import com.aptana.editor.php.internal.ui.editor.PHPSourceConfiguration;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;

final class SingleQuotedStringScanner
extends RuleBasedScanner {
    private static final IToken BEGIN_QUOTE = PHPSourceConfiguration.getToken(PHPTokenType.PUNCTUATION_STRING_BEGIN);
    private static final IToken CONTENTS = PHPSourceConfiguration.getToken(PHPTokenType.META_STRING_CONTENTS_SINGLE);
    private static final IToken END_QUOTE = PHPSourceConfiguration.getToken(PHPTokenType.PUNCTUATION_STRING_END);
    private boolean firstQuote = true;

    SingleQuotedStringScanner() {
        this.setDefaultReturnToken(CONTENTS);
        CharacterMapRule rule = new CharacterMapRule();
        rule.add('\'', BEGIN_QUOTE);
        this.setRules(new IRule[]{rule});
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        if (token.isOther() && PHPTokenType.PUNCTUATION_STRING_BEGIN.toString().equals(token.getData())) {
            if (this.firstQuote) {
                this.firstQuote = !this.firstQuote;
            } else {
                token = END_QUOTE;
            }
        }
        return token;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.firstQuote = true;
    }
}

